<?LassoScript

	var: 'cal_year' = (integer: (action_param: 'cal_year'));
	var: 'cal_month' = (integer: (action_param: 'cal_month'));
	var: 'cal_day' = (integer: (action_param: 'cal_day'));
	var: 'months' = (array: 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
	var: 'month_end' = 0;

	if: $cal_year != 0 && ($cal_month != 0);
		var: 'month_end' = (date: -month=$cal_month + 1, -year=$cal_year, -day=1)->(subtract: -day=1) & day;
		if: ($cal_day > $month_end) || ($cal_day < 1);
			var: 'cal_day' = 0;
		/if;
	/if;	
?>

[ljax_target: (array: 'page_frame'), -notarget]
	<p>Progressive Form</p>
	
	<p>This example shows how a form can be created which progressively shows new
	options as the user makes choices.  First a year is selected, then a month, and
	then a day. Finally the day is shown in a calendar</p>
	
	<p>This example can be used any time a site needs to guide the user through a
	complex series of choices.</p>

	<form action="index.lasso" method="post" onsubmit="Lasso.includeTarget('cal_display',{args:this}); return false;">
		<input type="hidden" name="page" value="progform" />
		
		<div id="cal_year" style="border-color: white; border-style: solid; border=width: 1px; margin: 6px; padding: 3px;">
			Year: 
			<select name="cal_year" onchange="Lasso.includeTarget('cal_display',{args:this.form, afterFunc:function(request){document.getElementById('cal_month').style.display = 'block';}});">
				<option value=""[if: $cal_year == 0] selected="selected"[/if]>Select a Year...</option>[loop: -from=2000, -to=2010]
				<option value="[loop_count]"[if: $cal_year == loop_count] selected="selected"[/if]>[loop_count]</option>[/loop]
			</select>
		</div>
[/ljax_target]

[ljax_target: (array: 'page_frame','cal_display'), -notarget]
		<div id="cal_month" style="[if: $cal_year == '']display: none; [/if]border-color: white; border-style: solid; border=width: 1px; margin: 6px; padding: 3px;"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
			[if: $cal_year != 0]
				Month: 
				<select name="cal_month" onchange="Lasso.includeTarget('cal_display',{args:this.form, afterFunc:function(request){document.getElementById('cal_day').style.display = 'block';}});">
					<option value=""[if: $cal_month == 0] selected="selected"[/if]>Select a Month...</option>[loop: 12]
					<option value="[loop_count]"[if: $cal_month == loop_count] selected="selected"[/if]>[$months->(get: loop_count)]</option>[/loop]
				</select>
			[/if]
		</div>
		
		<div id="cal_day" style="[if: $cal_month == '']display: none; [/if]border-color: white; border-style: solid; border=width: 1px; margin: 6px; padding: 3px;"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
			[if: $cal_month != 0]
				Day: 
				<select name="cal_day" onchange="Lasso.includeTarget('cal_display',{args:this.form, afterFunc:function(request){document.getElementById('cal_display').style.display = 'block';}});">
					<option value=""[if: $cal_day == 0] selected="selected"[/if]>Select a Day...</option>[loop: $month_end]
					<option value="[loop_count]"[if: $cal_day == loop_count] selected="selected"[/if]>[loop_count]</option>[/loop]
				</select>
			[/if]
		</div>

		<div id="cal_display" style="[if: $cal_day == 0]display: none; [/if]border-color: white; border-style: solid; border=width: 1px; margin: 6px; padding: 3px;"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
			<?LassoScript
				if: $cal_year != 0 && $cal_month != 0;
					var: 'start' = (date: -month=$cal_month, -year=$cal_year, -day=1);
					var: 'end' = (date: -month=$cal_month + 1, -year=$cal_year, -day=1)->(subtract: -day=1) &;
					var: 'length' = 42;
					var: 'start_pad' = $start->dayofweek;
					var: 'end_pad' = $length - $start_pad - $end->day;
					$start->(format: '%B %Y');
					'<table border="1" cellspacing="0" cellpadding="3" bordercolor="#cccccc">';
					'<tr>';
					'<td align="center">S</td>';
					'<td align="center">M</td>';
					'<td align="center">T</td>';
					'<td align="center">W</td>';
					'<td align="center">R</td>';
					'<td align="center">F</td>';
					'<td align="center">S</td>';
					'</tr>';
					'<tr>';
					loop: $length;
						if: loop_count < $start_pad;
							'<td>&#xA0;</td>';
						else: loop_count >= $length - $end_pad;
							'<td>&#xA0;</td>';
						else;
							var: 'day' = (loop_count - $start_pad + 1);
							if: $cal_day == $day;
								'<td align="right" bgcolor="white">'; $day; '</td>';
							else;
								'<td align="right">'; $day; '</td>';
							/if;
						/if;
						if: (loop_count % 7 == 0) && (loop_count != $length);
							'</tr><tr>';
						/if;
					/loop;
					'</tr>';
					'</table>';
				/if;
			?>
		</div>
[/ljax_target]

[ljax_target: (array: 'page_frame'), -notarget]		
		<p></p>
	</form>
[/ljax_target]